IF EXISTS (SELECT  *  FROM  sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UFD_TRILHO_EXCESSO_RET_FILIAL]') AND type IN ( N'TF' ))
    BEGIN
	   DROP FUNCTION [dbo].[UFD_TRILHO_EXCESSO_RET_FILIAL]
    END

GO
CREATE FUNCTION [dbo].[UFD_TRILHO_EXCESSO_RET_FILIAL] (@CD_MAQUINA INT)	

RETURNS @RS_RETORNO TABLE (	CD_EMP		INT,
							CD_FILIAL	INT,
							CD_TRILHO	INT, 
							ORDEM		INT,  
							ENVIA		INT,  
							RECEBE		INT)
AS
BEGIN

	-------------------------------------------------------------- 
	INSERT INTO @RS_RETORNO
	SELECT 
		D.CD_EMP,	
		D.CD_FILIAL,	
		MAX(A.CD_TRILHO)CD_TRILHO,
		MAX(D.ORDEM)	ORDEM,
		ABS(D.ENVIA)	ENVIA,
		ABS(D.RECEBE)	RECEBE
	FROM
		EST_EXCESSO_MAQ_TRILHO A
		INNER JOIN TRILHO B ON
		A.CD_EMP	= B.CD_EMP AND
		A.CD_TRILHO = B.CD_TRILHO
		
		INNER JOIN TRILHO_AGENDA C ON
		B.CD_EMP	= C.CD_EMP AND
		B.CD_TRILHO = C.CD_TRILHO
		
		INNER JOIN TRILHO_PRC_FILIAL D ON
		C.CD_EMP	= D.CD_EMP AND
		C.CD_TRILHO = D.CD_TRILHO AND 		
		C.CD_TRILHO_AGENDA = D.CD_TRILHO_AGENDA
		
		INNER JOIN 	EST_EXCESSO_MAQ E ON
		A.CD_EMP		 = E.CD_EMP AND
		A.CD_EXCESSO_MAQ = E.CD_EXCESSO_MAQ

	WHERE 
		B.STATUS = 0 --STATUS DO TRILHO
		AND E.STATUS=0 --STATUS DA MAQUINA		
		AND C.STATUS = 0 --STATUS DA AGENDA
		AND B.DT_INICIO <= DBO.F_HOJE() --DT INICIO DO TRILHO
		AND A.CD_EXCESSO_MAQ =@CD_MAQUINA
		AND (CASE WHEN (DATEPART(WEEKDAY, DBO.F_HOJE())) = 1 THEN --DOMINGO
			DOMINGO
		WHEN (DATEPART(WEEKDAY, DBO.F_HOJE())) = 2 THEN --SEGUNA
			SEGUNDA
		WHEN (DATEPART(WEEKDAY, DBO.F_HOJE())) = 3 THEN --TERCA
			TERCA
		WHEN (DATEPART(WEEKDAY, DBO.F_HOJE())) = 4 THEN --QUARTA
			QUARTA
		WHEN (DATEPART(WEEKDAY, DBO.F_HOJE())) = 5 THEN --QUINTA
			QUINTA
		WHEN (DATEPART(WEEKDAY, DBO.F_HOJE())) = 6 THEN --SEXTA
			SEXTA
		WHEN (DATEPART(WEEKDAY, DBO.F_HOJE())) = 7 THEN --SABADO
			SABADO
		END) = 1
    group by D.CD_EMP,	
	         D.CD_FILIAL,	
		--     D.ORDEM,
			 ABS(D.ENVIA),
			 ABS(D.RECEBE) 
	
--Retirando do trilho filial com balanco agendado
DELETE
	R
FROM
	@RS_RETORNO R inner join EST_PROD_BALAN_CRONOGRAMA ON
	R.CD_EMP = EST_PROD_BALAN_CRONOGRAMA.CD_EMP AND
	R.CD_FILIAL = EST_PROD_BALAN_CRONOGRAMA.CD_FILIAL 
WHERE
	DT_BALAN=CONVERT(CHAR(10),GETDATE(),112)
	AND NOT STS_BALAN IN (2, 3)


	IF NOT EXISTS (SELECT * FROM @RS_RETORNO)
		INSERT INTO @RS_RETORNO 
			SELECT 0, 0,0,0,0,0

RETURN
END
